/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.scope;

import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.scope.MatchContext;
import com.aptana.scope.SelectorNode;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NameSelector
extends SelectorNode {
    private String _name;
    private int matchLength = 0;

    public NameSelector(String name) {
        this._name = name;
    }

    @Override
    public List<Integer> getMatchResults() {
        return CollectionsUtil.newList((Object[])new Integer[]{this.matchLength});
    }

    @Override
    public boolean matches(MatchContext context) {
        String step;
        this.matchLength = 0;
        boolean result = false;
        if (context != null && !StringUtil.isEmpty((String)this._name) && (step = context.getCurrentStep()) != null && step.startsWith(this._name)) {
            int nameLength = this._name.length();
            int scopeLength = step.length();
            if (scopeLength == nameLength || step.charAt(nameLength) == '.') {
                result = true;
                this.matchLength = nameLength;
                context.advance();
            }
        }
        return result;
    }

    public String toString() {
        return this._name;
    }
}

